/* ============ */
/* setcolsn.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <clsndefs.h>
#include <miscdefs.h>

#define ACT(X)	#X

#define CLAMP(Out, Var, Lo, Hi) Out = __min(Hi, __max(Lo, Var))

#define NEED_ALL(Label) "Enter "Label

#define NEED_USER_ENTRY(LABEL, LO, HI) \
	NEED_ALL(LABEL" ["ACT(LO)"-"ACT(HI)"]: ")

#define BALLS_LABEL	"Number of Balls"
#define BITS_LABEL	"Number of Bits in Observations"
#define URN_LABEL	"Number of Urns"

#define REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL);printf("\n");			\
	printf("\tNumber Entered:  %.f", (double)Entry);\
	printf(" (%s)\n", Label);			\
    }
#define SHOW_INT_VALUE_USED(Entered, Used)			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

static int BitEntries[] = {1, 2, 4, 5, 10};
#define NUM_BIT_ENTRIES (sizeof(BitEntries)/sizeof(BitEntries[0]))

static double PctPts[] = { .01, .05, .25, .50, .75, .95, .99, 1.0};
/* ==================================================================== */
/* SetCollisionControls - Puts Run Controls in ClsnData structure	*/
/* ==================================================================== */
void
SetCollisionControls(CLSN_DATA_STRU * ClsnData)
{
    UINT    UserUintEntry;
    int     ItsSize, k, MySize;

    /* ------------------- */
    /* Get Number of Urns */
    /* ------------------- */
# if 0
    long    UserLongEntry;
    GetLong(NEED_USER_ENTRY(URN_LABEL, MIN_NUM_URNS, MAX_NUM_URNS),
	&UserLongEntry);

    REPORT_USER_INT_ENTRY(UserLongEntry, URN_LABEL);

    if (UserLongEntry == 0)
    {
	ClsnData->NumCategories = MAX_NUM_URNS;
    }
    else
    {
	CLAMP(ClsnData->NumCategories, UserLongEntry,
	    MIN_NUM_URNS, MAX_NUM_URNS);
    }
    SHOW_INT_VALUE_USED(UserLongEntry, ClsnData->NumCategories);
# endif

    ClsnData->NumCategories = MAX_NUM_URNS;

    /* ------------------- */
    /* Get Number of Balls */
    /* ------------------- */
# if 0
    GetUint(NEED_USER_ENTRY(BALLS_LABEL, MIN_NUM_BALLS, MAX_NUM_BALLS),
	&UserUintEntry);

    REPORT_USER_INT_ENTRY(UserUintEntry, BALLS_LABEL);

    if (UserUintEntry == 0)
    {
	ClsnData->NumObs = MAX_NUM_BALLS;
    }
    else
    {
	CLAMP(ClsnData->NumObs, UserUintEntry,
	    (UINT) MIN_NUM_BALLS, (UINT) MAX_NUM_BALLS);
    }
    SHOW_INT_VALUE_USED(UserUintEntry, ClsnData->NumObs);
# endif

    ClsnData->NumObs = MAX_NUM_BALLS;

    /* --------------------------------- */
    /* Get Number of Bits in Observation */
    /* --------------------------------- */
    printf("Requesting Number of Random Bits to be Used.\n"
	"Allowed Entries Are:\n");

    for (k = 0; k < NUM_BIT_ENTRIES; ++k)
    {
	printf("%4d%s", BitEntries[k],
	    (k < NUM_BIT_ENTRIES - 1) ? "," : "\n");
    }

    printf("Default is 1 Bit\n");

    GetUint(NEED_USER_ENTRY(BITS_LABEL, MIN_NUM_USER_BITS,
	    MAX_NUM_USER_BITS), &UserUintEntry);

    REPORT_USER_INT_ENTRY(UserUintEntry, BITS_LABEL);

    for (k = 0; k < NUM_BIT_ENTRIES; ++k)
    {
	if ((int) UserUintEntry == BitEntries[k])
	{
	    break;
	}
    }

    if (k == NUM_BIT_ENTRIES)
    {
	ClsnData->NumBits = 1;
    }
    else
    {
	ClsnData->NumBits = (int) UserUintEntry;
    }

    SHOW_INT_VALUE_USED(UserUintEntry, ClsnData->NumBits);

    /* ---------------------------------- */
    /* Set BitMask Used by GetBitVector() */
    /* ---------------------------------- */
    ClsnData->BitMask = (1 << ClsnData->NumBits) - 1;
    P(printf("ClsnData->BitMask  = %4x\n", ClsnData->BitMask));

    /* -------------------------------------------- */
    /* Set Number of Parts That Make Up Data Vector */
    /* -------------------------------------------- */
    ClsnData->NumParts = MAX_NUM_DATA_BITS / ClsnData->NumBits;
    P(printf("ClsnData->NumParts = %4d\n", ClsnData->NumParts));

    /* ---------------------------- */
    /* Initialize Percentage Points */
    /* ---------------------------- */
    MySize = sizeof(PctPts);
    ItsSize = sizeof(ClsnData->PctPts);

    memcpy(ClsnData->PctPts, PctPts, ItsSize);
    P(printf("SetCollisionControls(): "));

    if (MySize == ItsSize)
    {
	P(printf("Percentage Points Initilaized\n"));
    }
    else
    {
	/* Insert &MySize to Silence compiler */
	printf("Initializer for Percentage Points is too %s.\n",
	    (MySize < ItsSize) ? "SMALL" : "LARGE", &MySize);
    }
}
